(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     16457,        423]*)
(*NotebookOutlinePosition[     17134,        446]*)
(*  CellTagsIndexPosition[     17090,        442]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Un ejercicio de extremos relativos", "Section",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "En este ejercicio vamos a ver que una funci\[OAcute]n de dos variables \
puede tener infinitos m\[AAcute]ximos locales pero ning\[UAcute]n \
m\[IAcute]nimo local. Esto no puede ocurrir con funciones de una variable, \
\[DownQuestion]verdad? ",
  Cell[BoxData[
      RowBox[{
        StyleBox[\(La\ funci\[OAcute]n\ es\ f \((x, y)\)\),
          FontFamily->"Times New Roman"], 
        StyleBox["=",
          FontFamily->"Times New Roman"], 
        RowBox[{
          StyleBox[\(e\^\(-x\)\),
            FontFamily->"Times New Roman"], 
          RowBox[{
            StyleBox[\((x\ e\^\(-x\)\  + \ cos\ y)\),
              FontFamily->"Times New Roman"], 
            StyleBox[".",
              FontFamily->"Times New Roman"], " "}]}]}]]]
}], "Text",
  FontFamily->"Times New Roman"],

Cell["\<\
1.  Define la funci\[OAcute]n y repres\[EAcute]ntala gr\[AAcute]ficamente en \
la regi\[OAcute]n -1\[LessEqual]x\[LessEqual]4, -4\[Pi]\[LessEqual]y\
\[LessEqual]4\[Pi]. Haz tambi\[EAcute]n, con \"ContourPlot\"  un \
gr\[AAcute]fico de las curvas de nivel en la misma regi\[OAcute]n.\
\>", "Text",
  FontFamily->"Times New Roman"],

Cell["\<\
2. Calcula  los puntos cr\[IAcute]ticos de f. Para ello calcula  primero \
D[f[x,y],y] , D[f[x,\[Pi]],x]y  D[f[x,0],x]  y f\[IAcute]jate d\[OAcute]nde \
se anulan (puedes ayudarte con una representaci\[OAcute]n gr\[AAcute]fica). \
Ahora ya puedes deducir cu\[AAcute]les son los puntos cr\[IAcute]ticos de \
f.\
\>", "Text",
  FontFamily->"Times New Roman"],

Cell["\<\
3. Gr\[AAcute]ficamente, es evidente que los puntos cr\[IAcute]ticos tienen \
que ser m\[AAcute]ximos locales. Pru\[EAcute]balo.\
\>", "Text",
  FontFamily->"Times New Roman"]
}, Open  ]],

Cell[CellGroupData[{

Cell["El comando DSolve", "Section"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " puede resolver  ecuaciones diferenciales con el comando DSolve[ecuaci\
\[OAcute]n,funci\[OAcute]n,variable]. Observa c\[OAcute]mo funciona."
}], "Text"],

Cell[BoxData[
    \(DSolve[\(y'\)[x] == a\ y[x], y[x], x]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " indica que hay una constante arbitraria de integraci\[OAcute]n y la \
representa por C[1]. Para obtener la soluci\[OAcute]n que pasa por el punto \
(2,5) se escribe"
}], "Text"],

Cell[BoxData[
    \(DSolve[{\(y'\)[x] == a\ y[x], y[2] \[Equal] 5}, y[x], x]\)], "Input"],

Cell["\<\
Donde ya no aparece ninguna constante. Prueba a resolver las ecuaciones \
diferenciales siguientes.\
\>", "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox[\(\(\(\(\(\(\(\(\(\(\(a\)\()\)\)\ \ 2 \( 
                                        x\^2\) \[DifferentialD]y\/\
\[DifferentialD]x = 3  xy\  + \ y\^2; \ 
                                      y \((1)\) = \(-2\)\ \
;\[IndentingNewLine]
                                      \ 
                                      b\)\()\)\)\ \ \((x\^2 + 
                                        y\^2)\) \[DifferentialD]x\  + \ 
                                  x\ y\ \ \[DifferentialD]y\  = 0; \ 
                              c\)\()\)\)\ \ x\ \[DifferentialD]y\  + \ 
                          y\ \[DifferentialD]x\  = \ 
                        sen \((x)\) \[DifferentialD]x; \ d\)\()\)\)\ y' + 
                  2  y = e\^\(-x\); \ 
              e\)\()\)\) \((x + y)\) \[DifferentialD]x\),
          FontFamily->"Courier New"], 
        StyleBox[" ",
          FontFamily->"Courier New"], 
        StyleBox["+",
          FontFamily->"Courier New"], 
        StyleBox[" ",
          FontFamily->"Courier New"], 
        RowBox[{
          RowBox[{
            StyleBox["(",
              FontFamily->"Courier New"], 
            RowBox[{
              StyleBox["x",
                FontFamily->"Courier New"], 
              StyleBox["+",
                FontFamily->"Courier New"], 
              SuperscriptBox[
                StyleBox["y",
                  FontFamily->"Courier New"], "2"]}], 
            ")"}], \(\[DifferentialD]y\)}]}], " ", "=", "0"}]], "Text",
  TextAlignment->Left],

Cell[TextData[{
  "Observa que a veces la soluci\[OAcute]n es muy complicada, la \
raz\[OAcute]n es que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " proporciona siempre que puede la soluci\[OAcute]n de forma \
expl\[IAcute]cita. \nTambi\[EAcute]n puedes obtener una soluci\[OAcute]n \
particular de una ecuaci\[OAcute]n diferencial y representarla \
gr\[AAcute]ficamente."
}], "Text"],

Cell[BoxData[
    \(sol = 
      DSolve[{\(y'\)[x] \[Equal] \(-\((x + y[x])\)\^2\), 
          y[0] \[Equal] \(-2\)}, y[x], x]\)], "Input"],

Cell[BoxData[
    \(\(Plot[Evaluate[y[x] /. sol], {x, \(-3\), 3}];\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "C\[AAcute]lculo de una integral triple con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
    "Te", " ", "propongo", " ", "que", " ", "calcules", " ", "la", " ", 
      "integral", 
      FormBox[\(\(\(\[Integral]\(\[Integral]\[Integral]\)\)\+A\) \(x\^2\) \
\[DifferentialD]\((x, y, z)\)\),
        "TraditionalForm"], " ", "donde", " ", "A", " ", "es", " ", "el", " ",
       "conjunto", 
      RowBox[{
        FormBox[\(A = {\((x, y, z)\) : 
                x\^2 + y\^2 + \((z - 1)\)\^2 \[LessEqual] 1, \ 
              3\ z\^2 \[GreaterEqual] \ x\^2 + y\^2}\),
          "TraditionalForm"], ".", " ", "Este"}], " ", "ejercicio", " ", "lo",
       " ", "hemos", " ", "hecho", " ", "en", " ", "clase", " ", "hace", " ", 
      "unos", " ", "d\[IAcute]as", " ", "pero", " ", "considero", " ", 
      "instructivo", " ", "que", " ", "lo", " ", "hagas", " ", "con", 
      " ", \(\(Mathematica\)\(.\)\)}]], "Text",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Representa gr\[AAcute]ficamente el conjunto A. Para ello sigue los \
siguientes pasos:\nCalcula la intersecci\[OAcute]n de la esfera  ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 + \((z - 1)\)\^2 = 1\)]],
  " con el cono ",
  Cell[BoxData[
      \(TraditionalForm\`3\ z\^2 = \ x\^2 + y\^2\)]],
  "."
}], "Text",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(Reduce[{1/3\ \((x\^2 + y\^2)\), 
          x\^2 + y\^2 + \((z - 1)\)\^2} \[Equal] {\(\(z\)\(\ \)\)\^2, 
          1}]\)], "Input",
  FontFamily->"Courier New"],

Cell[BoxData[
    \(Este\ resultado\ nos\ dice\ que\ la\ intersecci\[OAcute]n\ de\ la\ \
esfera\ y\ el\ cono\ es\ el\ conjunto\ de\ puntos\ de\ la\ forma\ \((x, y, 
            1/2)\)\ \ donde\ 2  x\^2 + 2  y\^2 = 3/2; \ es\ decir, \ 
    la\ circunferencia\ situada\ en\ el\ plano\ z = 1/2, \ 
    centrada\ en\ \((0, 0, 1/2)\), \ de\ radio\ \@3/2. \)], "Text",
  FontFamily->"Times New Roman"],

Cell["\<\
Podemos representar ahora el cono cortado por el plano z=1/2.\
\>", "Text",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(\(graf1 = 
        Plot3D[Min[1/\@3\ \ \@\(\(\(x\)\(\ \)\)\^2 + \(\(y\)\(\ \)\)\^2\), 
            1/2], {x, \(-1.5\), 1.5}, {y, \(-1.5\), 1.5}, 
          AspectRatio \[Rule] 1, PlotPoints \[Rule] 100, Mesh -> False, 
          ViewPoint -> {2.090, \ \(-2.564\), \ 0.713}, 
          PlotRange \[Rule] All];\)\)], "Input",
  FontFamily->"Courier New"],

Cell["\<\
Podemos representar ahora la esfera variando la coordenada z desde z=1/2 \
hasta z=2. Para ello lo m\[AAcute]s f\[AAcute]cil es usar coordenadas esf\
\[EAcute]ricas.\
\>", "Text",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(\(graf2 = 
        ParametricPlot3D[{\ \ Cos[\[Theta]]\ Sin[\[Phi]], \ 
            Sin[\[Theta]] Sin[\[Phi]], 1 + Cos[\[Phi]]}, {\[Theta], \(-Pi\), 
            Pi}, {\[Phi], 0, ArcCos[\(-1\)/2]}, 
          AspectRatio \[Rule] Automatic, PlotPoints \[Rule] 50, 
          ViewPoint -> {2.090, \ \(-2.564\), \ 0.713}, 
          PlotRange \[Rule] All];\)\)], "Input",
  FontFamily->"Courier New"],

Cell["\<\
Ahora puedes ver juntas las dos gr\[AAcute]ficas (aunque la esfera parece un \
mel\[OAcute]n)\
\>", "Text",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(\(graf = 
        Show[graf1, graf2, 
          ViewPoint -> {\(-1.281\), \ \(-3.254\), \ \(-0.310\)}];\)\)], \
"Input",
  FontFamily->"Courier New"],

Cell[BoxData[
    \(Calcula\ ahora\ la\ integral\ integrando\ por\ secciones\ paralelas\ al\
\ plano\ XY\ \ F\[IAcute]jate\ que\ si\ 0 \[LessEqual] z \[LessEqual] 
        1/2\ entonces\ \ A\_\(\(z\)\(\ \)\) = \({\((x, 
            y)\), \((x, y, z)\) \[Epsilon]\ A} = {\((x, y)\) : \ 
            x\^2 + y\^2 \[LessEqual] 3  z\^2}\); \ 
    y\ \ si\ \ 1/2 \[LessEqual] z \[LessEqual] 2, \ 
    A\_\(\(z\)\(\ \)\) = \({\((x, 
            y)\), \((x, y, z)\) \[Epsilon]\ A} = \({\((x, y)\) : \ 
              x\^2 + y\^2 \[LessEqual] 
                1 - \((z - 1)\)\^2} = {\((x, y)\) : \ 
                  x\^2 + y\^2 \[LessEqual] 
                    2  z - z\^2} . \[IndentingNewLine]La\ integral\ podemos\ \
calcularla\ en\ la\ forma\)\)\)], "Text",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(\(\(\[Integral]\(\[Integral]\[Integral]\)\)\+A\) \(x\^2\) \
\[DifferentialD]\((x, y, 
            z)\) = \[Integral]\_0\%\(1/2\)\([\(\(\[Integral]\[Integral]\)\+\(\
A\_z\)\) \(x\^2\) \[DifferentialD]\((x, 
                    y)\)]\) \[DifferentialD]z + \
\[Integral]\_\(1/2\)\%2\([\(\(\[Integral]\[Integral]\)\+\(A\_z\)\) \(x\^2\) \
\[DifferentialD]\((x, y)\)]\) \[DifferentialD]z\)], "Text",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(La\ integrales\ dobles\ anteriores\ puedes\ calcularlas\ pasando\ a\ \
coordenadas\ polares . \ \ Concretamente, \ 
    para\ la\ primera\ puedes\ hacer\ el\ cambio\ x = \ \
\[Rho]\ \ Cos[\[Theta]], \ 
    y = \ \(\(\[Rho]\)\(\ \ \)\(Sin[\[Theta]] . \ 
          El\)\(\ \)\(determinante\)\(\ \)\(jacobiano\)\(\ \)\(del\)\(\ \
\)\(cambio\)\(\ \)\(es\)\(\ \)\)\)], "Text",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(\[Rho], \ con\ lo\ que\)], "Text",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(\[Integral]\_0\%\(1/2\)\([\(\(\[Integral]\[Integral]\)\+\(A\_z\)\) \
\(x\^2\) \[DifferentialD]\((x, 
                  y)\)]\) \[DifferentialD]z = \[Integral]\_0\%\(1/2\)\([\
\[Integral]\_\(-\[Pi]\)\%\[Pi]\([\[Integral]\_0\%\(\(\@3\) z\)\(\[Rho]\^3\) 
                      Cos[\[Theta]]\^2\ \[DifferentialD]\[Rho]]\) \
\[DifferentialD]\[Theta]]\) \[DifferentialD]z\)], "Text",
  FontFamily->"Times New Roman"],

Cell["\<\
De forma an\[AAcute]loga puedes calcular la otra integral. Hazlo para obtener \
la integral pedida.\
\>", "Text",
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(Calcula\ ahora\ la\ integral\ pedida\ proyectando\ primero\ el\ \
conjunto\ A\ sobre\ el\ plano\ XY\ y\ describiendo\ el\ intervalo\ de\ \
variaci\[OAcute]n\ de\ z\ para\ cada\ \((x, y)\) 
        en\ dicha\ proyecci\[OAcute]n . \ 
          F\[IAcute]jate\ que\ la\ proyecci\[OAcute]n\ de\ \ A\ sobre\ el\ \
plano\ XY\ \ es\ el\ disco\ unidad\ \ D = {\((x, y)\) : 
              x\^2 + y\^2 \[LessEqual] 1} . \ Si\ fijamos\ un\ punto\ \((x, 
          y)\) \[Epsilon]\ D, \ entonces\ si\ x\^2 + y\^2 \[LessEqual] 3/4, \ 
    z\ var\[IAcute]a\ en\ el\ intervalo\ que\ va\ de\ 1/\@3\ \ \@\(x^2 + \
y^2\)\ \ a\ \ 1 + \@\(1 - x\^2 - y\^2\)\ \((desde\ el\ cono\ hasta\ la\ parte\
\ superior\ de\ la\ esfera)\); \ 
    y\ si\ 3/4 \[LessEqual] \ x\^2 + y\^2 \[LessEqual] 1, \ 
    z\ var\[IAcute]a\ en\ el\ intervalo\ que\ va\ de\ \ \), "\
\[IndentingNewLine]", 
    \(1 - \@\(1 - x\^2 - y\^2\)\ \ a\ \ 1 + \ \@\(1 - x\^2 - y\^2\)\ \((entre\
\ la\ parte\ superior\ e\ inferior\ de\ la\ esfera)\) . \ 
          Representando\ por\ D \((0, \@3\/2)\)\ el\ disco\ de\ centro\ 0\ y\ \
radio\ \@3\/2, \ 
    y\ por\ A \((0, \@3\/2, 1)\)\ el\ anillo\ de\ radios\ \@3\/2\ \ y\ \ 1, \ 
    la\ integral\ puedes\ calcularla, \ \(\(como\)\(:\)\)\)}], "Text",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(\(\(\(\[Integral]\[Integral]\)\+\(D \((0, \@3/2)\)\)[\[Integral]\_\(\(\ \
\)\(\(1\/\@3\) \@\(x\^2 + y\^2\)\)\)\%\(\(1\)\(+\)\(\@\(1 - x\^2 - y\^2\)\)\(\
\ \)\)\(x\^2\) \[DifferentialD]z] \[DifferentialD]\((x, 
              y)\) + \(\[Integral]\[Integral]\)\+\(A \((0, \@3/2, 1)\)\)[\
\[Integral]\_\(\(\ \)\(1 - \@\(1 - x\^2 - y\^2\)\)\)\%\(\(1\)\(+\)\(\@\(1 - x\
\^2 - y\^2\)\)\(\ \)\)\(x\^2\) \[DifferentialD]z] \[DifferentialD]\((x, 
              y)\) = \(\(\[Integral]\[Integral]\)\+\(D \((0, \@3/
                    2)\)\)\) \(x\^2\) \((1 + \@\(1 - x\^2 - y\^2\)\  - \
\(1\/\@3\) \@\(\(x\^2\)\(+\)\(y\^2\)\(\ \)\))\) \[DifferentialD]\((x, 
              y)\) + \(\(\[Integral]\[Integral]\)\+\(A \((0, \@3/2, 1)\)\)\) 
          2\ \(x\^2\) \(\@\(1 - x\^2 - y\^2\)\) \[DifferentialD]\((x, 
              y)\)\)\(\ \)\(\[IndentingNewLine]\)
    \)\)], "Text",
  FontFamily->"Times New Roman"],

Cell["\<\
Utiliza coordenadas polares (con un cambio de escala) para calcular estas \
integrales. Comprueba que obtienes el mismo resultado que antes. \
\>", "Text",
  FontFamily->"Times New Roman"],

Cell["\<\
Finalmente, calcula directamente usando coordenadas esf\[EAcute]ricas, la \
integral pedida. Recuerda que las coordenadas esf\[EAcute]ricas vienen dadas \
por
x=\[Rho] Cos[\[Theta]] Sin[\[Phi]], y=\[Rho] Sin[\[Theta]] Sin[\[Phi]], z=\
\[Rho] Cos[\[Phi]]. Tenemos que:\
\>", "Text",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(B = \({\((\[Rho], \[Theta], \[Phi])\) : \((\[Rho]\ Cos[\[Theta]]\ Sin[\
\[Phi]], \[Rho]\ Sin[\[Theta]]\ Sin[\[Phi]], \[Rho]\ Cos[\[Phi]])\) \
\[Element] A} = \({\((\[Rho], \[Theta], \[Phi])\) : \ \[Rho] \[LessEqual] 
                2\ Cos[\[Phi]], 
            3\ \ Cos[\[Phi]]\^2 \[GreaterEqual] \ \ Sin[\[Phi]]\^2} = \({\((\
\[Rho], \[Theta], \[Phi])\) : \(-\[Pi]\) \[LessEqual] \[Theta] \[LessEqual] \
\[Pi], \ \[Rho] \[LessEqual] 2\ Cos[\[Phi]], 
              Tan[\[Phi]] \[LessEqual] \ \ 1/\@3} = {\((\[Rho], \[Theta], \
\[Phi])\) : \(-\[Pi]\) \[LessEqual] \[Theta] \[LessEqual] \[Pi], \ \[Rho] \
\[LessEqual] 2\ Cos[\[Phi]], 
              0 \[LessEqual] \[Phi] <= \[Pi]/3}\)\)\)\)], "Text",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(El\ determinante\ jacobiano\ de\ la\ transformaci\[OAcute]n\ es\ \((en\ \
valor\ absoluto)\)\ \(\[Rho]\^2\) Sin[\[Phi]] . \ Con\ ello, \ 
    la\ integral\ pedida\ es\ igual\ \(a : \
\[IndentingNewLine]\[Integral]\_\(-\[Pi]\)\%\[Pi]\([\[Integral]\_0\%\(\[Pi]/3\
\)\([\[Integral]\_0\%\(2  Cos[\[Phi]]\)\(\((\[Rho]\ Cos[\[Theta]]\ \
Sin[\[Phi]])\)\^2\) \(\[Rho]\^2\) 
                        Sin[\[Phi]] \[DifferentialD]\[Rho]]\) \
\[DifferentialD]\[Phi]]\) \[DifferentialD]\[Theta]\)\)], "Text",
  FontFamily->"Times New Roman"]
}, Open  ]]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowSize->{597, 540},
WindowMargins->{{Automatic, 31}, {Automatic, 7}},
StyleDefinitions -> "Default.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 86, 1, 59, "Section"],
Cell[1816, 55, 806, 20, 67, "Text"],
Cell[2625, 77, 339, 6, 52, "Text"],
Cell[2967, 85, 366, 7, 71, "Text"],
Cell[3336, 94, 185, 4, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3558, 103, 36, 0, 59, "Section"],
Cell[3597, 105, 224, 5, 52, "Text"],
Cell[3824, 112, 70, 1, 30, "Input"],
Cell[3897, 115, 249, 6, 52, "Text"],
Cell[4149, 123, 89, 1, 30, "Input"],
Cell[4241, 126, 123, 3, 33, "Text"],
Cell[4367, 131, 1539, 37, 94, "Text"],
Cell[5909, 170, 398, 9, 71, "Text"],
Cell[6310, 181, 139, 3, 31, "Input"],
Cell[6452, 186, 81, 1, 30, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6570, 192, 163, 5, 59, "Section"],
Cell[6736, 199, 883, 17, 92, "Text"],
Cell[7622, 218, 374, 10, 52, "Text"],
Cell[7999, 230, 179, 4, 31, "Input"],
Cell[8181, 236, 395, 6, 72, "Text"],
Cell[8579, 244, 118, 3, 33, "Text"],
Cell[8700, 249, 372, 7, 78, "Input"],
Cell[9075, 258, 222, 5, 52, "Text"],
Cell[9300, 265, 417, 8, 70, "Input"],
Cell[9720, 275, 150, 4, 33, "Text"],
Cell[9873, 281, 169, 5, 30, "Input"],
Cell[10045, 288, 786, 14, 90, "Text"],
Cell[10834, 304, 446, 8, 64, "Text"],
Cell[11283, 314, 424, 8, 50, "Text"],
Cell[11710, 324, 87, 2, 31, "Text"],
Cell[11800, 328, 430, 7, 64, "Text"],
Cell[12233, 337, 156, 4, 33, "Text"],
Cell[12392, 343, 1296, 21, 261, "Text"],
Cell[13691, 366, 917, 14, 167, "Text"],
Cell[14611, 382, 198, 4, 52, "Text"],
Cell[14812, 388, 324, 7, 71, "Text"],
Cell[15139, 397, 752, 12, 73, "Text"],
Cell[15894, 411, 547, 9, 85, "Text"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

